// Fill out your copyright notice in the Description page of Project Settings.


#include "PowerUp.h"

// Sets default values
APowerUp::APowerUp()
{
 	// Set this actor to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;

	// Create BoxComponent and set it as RootComponent
	m_box_component = CreateDefaultSubobject<UBoxComponent>("BoxComponent");
	RootComponent = m_box_component;

	// Create PaperSpriteComponent
	m_paper_sprite = CreateDefaultSubobject<UPaperSpriteComponent>("PaperSprite");

	// Make PaperSpriteComponent child of BoxComponent
	m_paper_sprite->SetupAttachment(m_box_component);

	// Make sure, that this class won't affect the NavMesh
	m_paper_sprite->SetCanEverAffectNavigation(false);
	m_box_component->SetCanEverAffectNavigation(false);
	
	// Set default sprite
	/*static ConstructorHelpers::FObjectFinder<UPaperSprite> SpriteAsset(TEXT("/Script/Paper2D.PaperSprite'/Game/Sprites/Pickup_Health_Sprite.Pickup_Health_Sprite'"));
	if (SpriteAsset.Succeeded())
	{
		m_paper_sprite->SetSprite(SpriteAsset.Object);
		m_paper_sprite->SetWorldScale3D(FVector(0.33, 0.33, 0.33));
		m_paper_sprite->SetWorldRotation(FRotator(0,0,-70));
	}*/

	m_paper_sprite->SetCollisionProfileName(TEXT("NoCollision"));
	m_box_component->SetCollisionProfileName(TEXT("Powerup"));

	// Bind the beginOverlap event to the OnBeginOverlap function
	m_box_component->OnComponentBeginOverlap.AddDynamic(this, &APowerUp::OnBeginOverlap);
}

// Called when the game starts or when spawned
void APowerUp::BeginPlay()
{
	Super::BeginPlay();
	
}

// Called every frame
void APowerUp::Tick(const float DeltaTime)
{
	Super::Tick(DeltaTime);

}

void APowerUp::OnBeginOverlap(UPrimitiveComponent* OverlappedComp,AActor* OtherActor,UPrimitiveComponent* OtherComp,int32 OtherBodyIndex, bool bFromSweep,const FHitResult& SweepResult)
{
	this->Destroy();
}
