#include "MovingPlatform.h"
#include "PaperSprite.h"
#include "PaperSpriteComponent.h"

AMovingPlatform::AMovingPlatform()
{
	PrimaryActorTick.bCanEverTick = true;

	PlatformSprite = CreateDefaultSubobject<UPaperSpriteComponent>(TEXT("PlatformSprite"));
	RootComponent = PlatformSprite;

	bMovingForward = true;
}

void AMovingPlatform::BeginPlay()
{
	Super::BeginPlay();
	CurrentPosition = GetActorLocation().Z;
	
}

void AMovingPlatform::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);

	if (bMoveVertically)
	{
		if (bMovingForward)
		{
			CurrentPosition += MoveSpeed * DeltaTime;
			if (CurrentPosition >= MaxPosition)
			{
				bMovingForward = false;
			}
		}
		else
		{
			CurrentPosition -= MoveSpeed * DeltaTime;
			if (CurrentPosition <= MinPosition)
			{
				bMovingForward = true;
			}
		}
	}
	else
	{
		if (bMovingForward)
		{
			CurrentPosition += MoveSpeed * DeltaTime;
			if (CurrentPosition >= MaxPosition)
			{
				bMovingForward = false;
			}
		}
		else
		{
			CurrentPosition -= MoveSpeed * DeltaTime;
			if (CurrentPosition <= MinPosition)
			{
				bMovingForward = true;
			}
		}
	}


	if (bMoveVertically)
	{
		SetActorLocation(FVector(GetActorLocation().X, GetActorLocation().Y, CurrentPosition));
	}
	else
	{
		SetActorLocation(FVector(CurrentPosition, GetActorLocation().Y, GetActorLocation().Z));
	}
}

