#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "KeyPickup.generated.h"

UENUM(BlueprintType)
enum class EKeyColor : uint8
{
    Red UMETA(DisplayName = "Red"),
    Blue UMETA(DisplayName = "Blue")
};

UCLASS()
class HUETOGETHER_API AKeyPickup : public AActor
{
    GENERATED_BODY()

public:
    AKeyPickup();

protected:
    virtual void BeginPlay() override;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Key")
    EKeyColor KeyColor;

    UFUNCTION()
    void OnOverlapBegin(class UPrimitiveComponent* OverlappedComp,
        class AActor* OtherActor,
        class UPrimitiveComponent* OtherComp,
        int32 OtherBodyIndex,
        bool bFromSweep,
        const FHitResult& SweepResult);

    void CheckPlayerTags();
    void DestroyKey();

public:
    virtual void Tick(float DeltaTime) override;

    UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Key")
    float HoverSpeed = 3.0f;

    UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Key")
    float HoverAmplitude = 5.0f;

    UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Key")
    float FollowSpeed = 5.0f;

    UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Key")
    FVector FollowOffset = FVector(0, 0, 0);

private:
    UPROPERTY(VisibleAnywhere)
    class UBoxComponent* CollisionBox;

    UPROPERTY(VisibleAnywhere)
    class UPaperSpriteComponent* KeySprite;

    FVector InitialPosition;
    bool bIsFollowingPlayer = false;
    AActor* PlayerReference = nullptr;
};
