#include "Door.h"
#include "Components/BoxComponent.h"
#include "PaperSprite.h"
#include "PaperSpriteComponent.h"
#include "Engine/Engine.h"
#include "KeyPickup.h"
#include "GameFramework/Actor.h"
#include "Kismet/GameplayStatics.h"

ADoor::ADoor()
{
    PrimaryActorTick.bCanEverTick = true;

    CollisionBox = CreateDefaultSubobject<UBoxComponent>(TEXT("CollisionBox"));
    RootComponent = CollisionBox;

    DoorSprite = CreateDefaultSubobject<UPaperSpriteComponent>(TEXT("DoorSprite"));
    DoorSprite->SetupAttachment(RootComponent);

    bIsOpen = false;

    if (DoorColor == EDoorColor::Red)
    {
        static ConstructorHelpers::FObjectFinder<UPaperSprite> RedDoorSprite(TEXT("PaperSprite'/Game/Sprites/Objects/door_red_Sprite.door_red_Sprite'"));
        if (RedDoorSprite.Succeeded())
        {
            DoorSprite->SetSprite(RedDoorSprite.Object);
        }
    }
    else if (DoorColor == EDoorColor::Blue)
    {
        static ConstructorHelpers::FObjectFinder<UPaperSprite> BlueDoorSprite(TEXT("PaperSprite'/Game/Sprites/Objects/door_blue_Sprite.door_blue_Sprite'"));
        if (BlueDoorSprite.Succeeded())
        {
            DoorSprite->SetSprite(BlueDoorSprite.Object);
        }
    }

    CollisionBox->SetCollisionEnabled(ECollisionEnabled::QueryAndPhysics);
    CollisionBox->SetCollisionResponseToAllChannels(ECR_Overlap);
    CollisionBox->OnComponentBeginOverlap.AddDynamic(this, &ADoor::OnOverlapBegin);
}

void ADoor::BeginPlay()
{
    Super::BeginPlay();

    if (DoorColor == EDoorColor::Red)
    {
        UPaperSprite* RedDoorSprite = Cast<UPaperSprite>(StaticLoadObject(UPaperSprite::StaticClass(), nullptr, TEXT("PaperSprite'/Game/Sprites/Objects/door_lock_red_Sprite.door_lock_red_Sprite'")));
        if (RedDoorSprite)
        {
            DoorSprite->SetSprite(RedDoorSprite);
        }
    }
    else if (DoorColor == EDoorColor::Blue)
    {
        UPaperSprite* BlueDoorSprite = Cast<UPaperSprite>(StaticLoadObject(UPaperSprite::StaticClass(), nullptr, TEXT("PaperSprite'/Game/Sprites/Objects/door_lock_blue_Sprite.door_lock_blue_Sprite'")));
        if (BlueDoorSprite)
        {
            DoorSprite->SetSprite(BlueDoorSprite);
        }
    }
}


void ADoor::Tick(float DeltaTime)
{
    Super::Tick(DeltaTime);
}

void ADoor::OnOverlapBegin(UPrimitiveComponent* OverlappedComp, AActor* OtherActor,
    UPrimitiveComponent* OtherComp, int32 OtherBodyIndex,
    bool bFromSweep, const FHitResult& SweepResult)
{
    if (OtherActor && OtherActor->ActorHasTag("Player"))
    {
        if (OtherActor->ActorHasTag("HasRedKey") && DoorColor == EDoorColor::Red)
        {
            OpenDoor();
            OtherActor->Tags.Remove("HasRedKey");
        }
        else if(OtherActor->ActorHasTag("HasBlueKey") && DoorColor == EDoorColor::Blue)
        {
            OpenDoor();
            OtherActor->Tags.Remove("HasBlueKey");
        }       
    }
}

void ADoor::OpenDoor()
{
    if (!bIsOpen)
    {
        bIsOpen = true;

        if (OpenDoorSound)
        {
            UGameplayStatics::PlaySoundAtLocation(this, OpenDoorSound, GetActorLocation());
        }

        Destroy();
    }
}
