#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "MovingPlatform.generated.h"

UCLASS()
class HUETOGETHER_API AMovingPlatform : public AActor
{
	GENERATED_BODY()
	
public:	
	AMovingPlatform();

protected:
	virtual void BeginPlay() override;

public:
	virtual void Tick(float DeltaTime) override;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Platform Movement")
	float MoveSpeed = 3.0f;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Platform Movement")
	bool bMoveVertically = true;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Platform Movement")
	float MinPosition;

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Platform Movement")
	float MaxPosition;

private:
	UPROPERTY(VisibleAnywhere, Category = "Platform Movement")
	float CurrentPosition;

	UPROPERTY(VisibleAnywhere, Category = "Platform Movement")
	bool bMovingForward;

	UPROPERTY(VisibleAnywhere)
	class UPaperSpriteComponent* PlatformSprite;
};
