// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "BaseCharacter.h"
#include "CoreMinimal.h"
#include "EngineUtils.h"
#include "GameFramework/Character.h"
#include "GridGenerator.h"
#include "InputActionValue.h" // Required for Enhanced Input
#include "Item.h"
#include <InputActionValue.h>

#include "PlayerCharacter.generated.h"

class UInputMappingContext;
class UInputAction;

/**
 *
 */
UCLASS()
class CHOMPNCROSS_API APlayerCharacter : public ACharacter {
  GENERATED_BODY()

protected:
  virtual void BeginPlay() override;
  virtual void Tick(float DeltaTime) override;
  virtual void BeginDestroy() override;

public:
  APlayerCharacter();

  void NotifyActorBeginOverlap(AActor *OtherActor);

  virtual void
  SetupPlayerInputComponent(UInputComponent *PlayerInputComponent) override;

  UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Player")
  int Lives;

  UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = "Player")
  int CurrentLives;

  UFUNCTION(BlueprintCallable, Category = "Player")
  virtual int getCurrentScore() const;

  UFUNCTION(BlueprintCallable, Category = "Player")
  virtual int getCurrentLives() const;

  // Input Mapping Context
  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Input")
  UInputMappingContext *InputMappingContext;

  // Input Action for Movement
  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Input")
  UInputAction *IA_Move;

  // Handles movement input
  void handleMoveInput(const FInputActionValue &Value);

  // dying mechanic
  UFUNCTION(BlueprintCallable, Category = "Player")
  void playerDies();

private:
  UFUNCTION()
  // subtract lives by amount
  void updateLives(int ToSubtract);

  UFUNCTION()
  void eatItem(AItem *Item);

  UFUNCTION(BlueprintCallable)
  void updateCurrentScore(int ScoreToAdd);

  UPROPERTY(VisibleAnywhere, Category = "Player")
  int CurrentScore;

  float MovementSize = 150.0f;

  UPROPERTY(EditAnywhere, Category = "Movement")
  float MovementDuration = 0.2f;

  bool bIsMoving = false;
  FTimerHandle InactivityTimerHandle;
  bool bHasInput; // input checker
  void checkInactivity();

  AGridGenerator *GridGenerator;
  AGridGenerator *locateGridGenerator();
};
