#pragma once

#include "BaseTile.h"
#include "Components/BillboardComponent.h"
#include "CoreMinimal.h"
#include "GameFramework/Actor.h"

#include "GridGenerator.generated.h"

/**
 * @brief Grid Generator class. Creates a grid with tiles by entering the number
 * of rows and columns required
 *
 */
UCLASS()
class CHOMPNCROSS_API AGridGenerator : public AActor {
  GENERATED_BODY()

public:
  AGridGenerator();

  /** initializes the tiles  */
  UFUNCTION(BlueprintImplementableEvent, BlueprintCallable, CallInEditor)
  void InitializeTiles();

  /** clears the tiles so a new grid can be created */
  UFUNCTION(BlueprintImplementableEvent, BlueprintCallable, CallInEditor)
  void ClearTiles();

protected:
  virtual void BeginPlay() override;

public:
  /** billdboard is used as an actor to generate the grid  */
  UPROPERTY(BlueprintReadOnly, VisibleAnywhere, Category = "Default")
  TObjectPtr<UBillboardComponent> Billboard;

  /** number of rows the grid should have */
  UPROPERTY(BlueprintReadWrite, VisibleAnywhere, Category = "Default")
  int32 Rows;

  /** number of columns the grid should have */
  UPROPERTY(BlueprintReadWrite, VisibleAnywhere, Category = "Default")
  int32 Columns;

  // Array to store references to BaseTile actors
  UPROPERTY(BlueprintReadWrite, VisibleAnywhere, Category = "Grid")
  TArray<ABaseTile *> Tiles;

  /** returns the tiles array */
  UFUNCTION(BlueprintCallable, Category = "Grid")
  const TArray<ABaseTile *> &getTilesArray() const;

  /** returns an array of tiles that can be spawned on */
  UFUNCTION(BlueprintCallable, Category = "Grid")
  TArray<ABaseTile *> getSpawnableTiles() const;

  /** the number of tiles in the grid */
  UPROPERTY(BlueprintReadWrite, EditDefaultsOnly, Category = "Default")
  int32 NumberOfTiles;

  /** updates the number of tiles in the grid once level starts */
  UFUNCTION(BlueprintCallable, Category = "Grid")
  int32 setNumberOfTiles();

  /** returns true if the tile at location can be spawned on */
  UFUNCTION(BlueprintCallable, Category = "Grid")
  bool isTileSpawnableAtLocation(const FVector &Location) const;

#if WITH_EDITOR
  virtual void
  PostEditChangeProperty(FPropertyChangedEvent &PropertyChangedEvent) override;
#endif
};
