// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "Components/BoxComponent.h"
#include "Components/StaticMeshComponent.h"
#include "CoreMinimal.h"
#include "GridGenerator.h"

#include "GameFramework/Pawn.h"
#include "Ghost.generated.h"

/**
 *
 */

// class AGridGenerator;

UCLASS()
class CHOMPNCROSS_API AGhost : public APawn {
  GENERATED_BODY()

public:
  AGhost();

  UPROPERTY(EditAnywhere)
  UStaticMeshComponent *BaseMesh;

  UPROPERTY(EditAnywhere, Category = "Movement")
  float MovementInterval = 1.0f; // movement speed

  UPROPERTY(VisibleAnywhere)
  UBoxComponent *CollisionMesh = nullptr;

protected:
  virtual void BeginPlay() override;
  virtual void Tick(float DeltaTime) override;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Ghost")
  FColor GhostColor;

private:
  UFUNCTION(BlueprintCallable, Category = "Ghost")
  void moveRandomly();

  FTimerHandle MovementTimerHandle;

  float MovementSize = 150.0f;

  AGridGenerator *GridGenerator;

  // checks if ghost can move to the tile
  bool canMoveTo(FVector TargetLocation);

  // picks random direction
  FVector getRandomdirection() const;

  // pointer reference to grid
  AGridGenerator *locateGridGenerator();

  // stores last position
  FVector LastDirection;
};
