#pragma once

#include "Apple.h"
#include "Banana.h"
#include "BaseCharacter.h"
#include "Coin.h"
#include "CoreMinimal.h"

#include "GameFramework/GameModeBase.h"
#include "GridGenerator.h"
#include "Orange.h"
#include "Strawberry.h"
#include <Ghost.h>
#include <PlayerCharacter.h>

#include "CrossNChompGameMode.generated.h"
/**
 * game mode for Chomp N Cross. Sets all needed classes to the correct ones by
 * default. Is also responsible for spawning items
 */
UCLASS()
class CHOMPNCROSS_API ACrossNChompGameMode : public AGameModeBase {
  GENERATED_BODY()

public:
  // constructor
  ACrossNChompGameMode();
  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Player")
  TSubclassOf<APlayerCharacter> PlayerClass;

  // makes sure that we get both the class and its subclasses ( like bps )
  UPROPERTY(EditDefaultsOnly, Category = "Ghosts")
  TArray<TSubclassOf<AGhost>> GhostClasses;

  // coin class
  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Items")
  TSubclassOf<ACoin> CoinClass;

  // all fruits
  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Items")
  TSubclassOf<AOrange> OrangeClass;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Items")
  TSubclassOf<AApple> AppleClass;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Items")
  TSubclassOf<ABanana> BananaClass;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Items")
  TSubclassOf<AStrawberry> StrawberryClass;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Items")
  int32 NumberOfCoins = 10; // Number of coins to spawn

  UFUNCTION(BlueprintCallable, Category = "Game")
  void EndGame();

protected:
  virtual void BeginPlay() override;

private:
  UPROPERTY(EditAnywhere, Category = "Ghosts")
  int32 NumberOfGhosts = 12; // Number of ghosts to spawn

  // spawns ghosts and items
  void spawnItems();

  // pointer reference to ensure grid exists
  AGridGenerator *checkGrid();
};
