#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"

#include "BaseTile.generated.h"

/**
 * @brief Construct a new UCLASS object
 * base tile used for the grid
 */
UCLASS()
class CHOMPNCROSS_API ABaseTile : public AActor {
  GENERATED_BODY()

public:
  // constructor
  ABaseTile();

  /** row location */
  UPROPERTY(BlueprintReadWrite, EditAnywhere, meta = (ExposeOnSpawn = true),
            Category = "Default")
  int32 Row;

  /** column location */
  UPROPERTY(BlueprintReadWrite, EditAnywhere, meta = (ExposeOnSpawn = true),
            Category = "Default")
  int32 Column;

  /* whether the tile can be spawned on - if false, is used for walls */
  UPROPERTY(BlueprintReadWrite, EditAnywhere, meta = (ExposeOnSpawn = true),
            Category = "Default")
  bool bSpawnable = true;

protected:
  // Called when the game starts or when spawned
  virtual void BeginPlay() override;

public:
  // Called every frame
  virtual void Tick(float DeltaTime) override;
};
