// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "UObject/NoExportTypes.h"

#include "ScoreManager.generated.h"
/**
 *
 */
UCLASS()
class CHOMPNCROSS_API UScoreManager : public UObject {
  GENERATED_BODY()

public:
  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Score")
  int CurrentScore;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Score")
  int HighScore;

  UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Score")
  TArray<int> ScoreList;

  UFUNCTION(BlueprintCallable, Category = "Score")
  int getCurrentScore() const;

  UFUNCTION(BlueprintCallable, Category = "Score")
  int GetHighScore() const;

  UFUNCTION(BlueprintCallable, Category = "Score")
  TArray<int> GetScoreList() const;
};
