#pragma once

#include "Components/BoxComponent.h"
#include "Components/StaticMeshComponent.h"
#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "Item.generated.h"

UCLASS()
class CHOMPNCROSS_API AItem : public AActor {
  GENERATED_BODY()

public:
  AItem();

  UPROPERTY(EditAnywhere, Category = "Item")
  UStaticMeshComponent *BaseMesh;

  UPROPERTY(VisibleAnywhere)
  UBoxComponent *CollisionMesh = nullptr;

  UFUNCTION(BlueprintCallable, Category = "Item")
  virtual int getValue() const;

  UFUNCTION(BlueprintCallable, Category = "Item")
  virtual FVector getPosition() const;

protected:
  // Called when the game starts or when spawned
  virtual void BeginPlay() override;

  int Value;

public:
  // Called every frame
  virtual void Tick(float DeltaTime) override;
};
