// Fill out your copyright notice in the Description page of Project Settings.

#include "Item.h"
#include "Engine/World.h"
#include "Kismet/KismetMathLibrary.h"

/**
 * @brief Construct a new AItem::AItem object
 *  base class for all items
 */
AItem::AItem() {
  BaseMesh = CreateDefaultSubobject<UStaticMeshComponent>(TEXT("Base Mesh"));
  BaseMesh->SetGenerateOverlapEvents(true);
  BaseMesh->SetCollisionObjectType(ECC_Pawn);

  // collision mesh

  CollisionMesh = CreateDefaultSubobject<UBoxComponent>(TEXT("Collision Box"));
  CollisionMesh->InitBoxExtent(FVector(50));
  CollisionMesh->SetCollisionObjectType(ECC_Pawn);
  CollisionMesh->SetCollisionResponseToChannel(ECC_Pawn, ECR_Overlap);
  CollisionMesh->SetGenerateOverlapEvents(true);

  BaseMesh->SetupAttachment(CollisionMesh);
  SetRootComponent(CollisionMesh);
}

/**
 * @brief returns value of the item
 *
 * @return int
 */
int AItem::getValue() const { return Value; }

/**
 * @brief returns position of the item
 *
 * @return FVector
 */
FVector AItem::getPosition() const { return GetActorLocation(); }

// Called when the game starts or when spawned
void AItem::BeginPlay() { Super::BeginPlay(); }

// Called every frame
void AItem::Tick(float DeltaTime) { Super::Tick(DeltaTime); }
