#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "SnakeGrid.generated.h"

UCLASS()
class SNAKE_API ASnakeGrid : public AActor
{
    GENERATED_BODY()
    
public:    
    ASnakeGrid();

protected:
    virtual void BeginPlay() override;

public:    
    virtual void Tick(float DeltaTime) override;

    UFUNCTION(BlueprintCallable, Category = "Snake Game")
    FVector GridToWorld(int32 X, int32 Y);

    bool IsOutOfBounds(FIntPoint Pos) const 
    { 
        return Pos.X < 0 || Pos.X >= GridSizeX || Pos.Y < 0 || Pos.Y >= GridSizeY; 
    }

    // Diese Funktion spawnt das Futter an einer zufälligen Stelle
    UFUNCTION(BlueprintCallable, Category = "Snake Game")
    void SpawnFood();

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Grid Settings")
    int32 GridSizeX = 20;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Grid Settings")
    int32 GridSizeY = 20;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Grid Settings")
    float CellSize = 100.0f;

    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Grid Settings")
    TSubclassOf<AActor> FoodClass;

private:
    AActor* CurrentFood;
};