// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "PaperSpriteActor.h"
#include "Obstacle.generated.h"

class ALumaPaperCharacter;
class UPaperSpriteComponent;

UCLASS(Abstract)
class LUMA2DSCROLLER_API AObstacle : public APaperSpriteActor
{
	GENERATED_BODY()
	
    public:
        // Sets default values for this actor's properties
        AObstacle();

    protected:
        // Called when the game starts or when spawned
       // virtual void BeginPlay() override;
    
        // 🔹 Wird von Unterklassen überschrieben
        UFUNCTION(BlueprintCallable)
        virtual void OnPlayerEnter(ALumaPaperCharacter* Player);
        UFUNCTION(BlueprintCallable)
        virtual void OnPlayerExit(ALumaPaperCharacter* Player);

        // 🔹 Collision zentral geregelt
        virtual void NotifyActorBeginOverlap(AActor* OtherActor) override;
        virtual void NotifyActorEndOverlap(AActor* OtherActor) override;

    public:

        /** Obstacle X position in 2D world */
        UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Obstacle|2D")
        float X;

        /** Obstacle Y position in 2D world */
        UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Obstacle|2D")
        float Y;

        /** Obstacle width */
        UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Obstacle|2D")
        float Width;

        /** Obstacle height */
        UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Obstacle|2D")
        float Height;
};
