// Fill out your copyright notice in the Description page of Project Settings.

#include "Obstacle.h"
#include "PaperSpriteComponent.h"
#include "LumaPaperCharacter.h"

// Sets default values
AObstacle::AObstacle()
{
    // Set this actor to call Tick() every frame.
    PrimaryActorTick.bCanEverTick = false;
    
    // Default 2D values
    X = 0.f;
    Y = 0.f;
    Width = 100.f;
    Height = 100.f;
}

// Called when the game starts or when spawned
/* AObstacle::BeginPlay()
{
    Super::BeginPlay();
    
    // Set initial 2D position
    SetActorLocation(FVector(X, Y, 0.f));

    // Optionally, call Spawn() at begin play
    //Spawn();
}*/

/** Called every frame
void AObstacle::Tick(float DeltaTime)
{
    Super::Tick(DeltaTime);

    // Optional: hier könntest du 2D-Bewegung oder Interaktion abfragen
} */

void AObstacle::NotifyActorBeginOverlap(AActor* OtherActor)
{
    Super::NotifyActorBeginOverlap(OtherActor);

    if (ALumaPaperCharacter* Player = Cast<ALumaPaperCharacter>(OtherActor))
    {
        OnPlayerEnter(Player);
    }
}

void AObstacle::NotifyActorEndOverlap(AActor* OtherActor)
{
    Super::NotifyActorEndOverlap(OtherActor);

    if (ALumaPaperCharacter* Player = Cast<ALumaPaperCharacter>(OtherActor))
    {
        OnPlayerExit(Player);
    }
}

// 🔹 Default-Implementierung (leer!)
void AObstacle::OnPlayerEnter(ALumaPaperCharacter* Player)
{
}

void AObstacle::OnPlayerExit(ALumaPaperCharacter* Player)
{
}
