// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "PaperCharacter.h"
#include "LumaPaperCharacter.generated.h"

/**
 * 
 */
UCLASS()
class LUMA2DSCROLLER_API ALumaPaperCharacter : public APaperCharacter
{
    GENERATED_BODY()

public:
    ALumaPaperCharacter();
    
    UPROPERTY(BlueprintReadOnly)
    bool bIsDead = false;
    
    UFUNCTION(BlueprintCallable)
    void Lose();
    
    /** ===== ENERGY ===== */
    /** Aktuelle Energie */
    UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category="Energy")
    float CurrentEnergy;

    /** Maximale Energie */
    UPROPERTY(EditDefaultsOnly, BlueprintReadOnly, Category="Energy")
    int32 MaxEnergy = 1000;
    
    /** Minimale Energie */
    UPROPERTY(EditDefaultsOnly, BlueprintReadOnly, Category="Energy")
    int32 MinEnergy = 0;

    /** Energieverbrauch pro Sekunde */
    UPROPERTY(EditAnywhere, BlueprintReadOnly, Category="Energy")
    int32 EnergyDrainRate = 10;

    UFUNCTION(BlueprintCallable, Category="Energy")
    void ChangeEnergyDrainRate(float Amount);

    /** Energie verändern (+ / -) */
    UFUNCTION(BlueprintCallable, Category="Energy")
    void ChangeEnergy(float Amount);
    
    
    // === Slow State ===
    UFUNCTION(BlueprintCallable, Category="Player|State")
    void SetWebbed(bool bNewWebbed);

    UFUNCTION(BlueprintPure, Category="Player|State")
    bool IsWebbed() const;

    // === Jump Check ===
    virtual bool CanJumpInternal_Implementation() const override;
    
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Glow")
    bool bIsGlowing = false;

protected:
    // Called when the game starts or when spawned
    virtual void BeginPlay() override;
    virtual void Tick(float DeltaTime) override;
    
private:
    //nur zum Test, kann später weg
    void DrawEnergy();
    
    bool bIsWebbed = false;

    float DefaultMaxWalkSpeed = 0.f;

    UPROPERTY(EditAnywhere, Category="Player|Movement")
    float WebbedSpeedMultiplier = 0.25f; // 25% Speed
    
    
    /** === MOVEMENT ===
    UPROPERTY()
    bool bMovementLocked = false;
    
    // === ENERGY ===
    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Player|Stats", meta=(AllowPrivateAccess="true"))
    float CurrentEnergy = 100.f;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="Player|Stats", meta=(AllowPrivateAccess="true"))
    float MaxEnergy = 100.f;

public:
    // Called every frame
    virtual void Tick(float DeltaTime) override;

    // Called to bind functionality to input
    virtual void SetupPlayerInputComponent(class UInputComponent* PlayerInputComponent) override;
    
    //Energy
    UFUNCTION(BlueprintCallable, Category="Player|Stats")
    void ChangeEnergy(float Amount);
    
    // Movable
    UFUNCTION(BlueprintCallable, Category="Player|State")
    void DisableMovement();

    UFUNCTION(BlueprintCallable, Category="Player|State")
    void EnableMovement(); */

};
