// Fill out your copyright notice in the Description page of Project Settings.


#include "LumaPaperCharacter.h"
#include "GameFramework/CharacterMovementComponent.h"

// Sets default values
ALumaPaperCharacter::ALumaPaperCharacter()
{
    // Set this character to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
    PrimaryActorTick.bCanEverTick = true;
    
    CurrentEnergy = MaxEnergy;
}

// Called when the game starts or when spawned
void ALumaPaperCharacter::BeginPlay()
{
    Super::BeginPlay();
    
    DefaultMaxWalkSpeed = GetCharacterMovement()->MaxWalkSpeed;
}

void ALumaPaperCharacter::Tick(float DeltaTime)
{
    Super::Tick(DeltaTime);
    
    if (CurrentEnergy <= MinEnergy || GetActorLocation().Z < -3000.f)
    {
        Lose();
    }

    ChangeEnergy(-EnergyDrainRate * DeltaTime);
}

void ALumaPaperCharacter::Lose()
{
    if (bIsDead) return; // nur einmal ausführen

    bIsDead = true;
}

void ALumaPaperCharacter::ChangeEnergyDrainRate(float Amount)
{
    EnergyDrainRate = Amount;
}

void ALumaPaperCharacter::ChangeEnergy(float Amount)
{
    CurrentEnergy = FMath::Clamp(CurrentEnergy + Amount, 0.f, (float)MaxEnergy);
}

void ALumaPaperCharacter::SetWebbed(bool bNewWebbed)
{
    if (bIsWebbed == bNewWebbed)
        return;

    bIsWebbed = bNewWebbed;

    if (bIsWebbed)
    {
        GetCharacterMovement()->MaxWalkSpeed =
            DefaultMaxWalkSpeed * WebbedSpeedMultiplier;
    }
    else
    {
        GetCharacterMovement()->MaxWalkSpeed = DefaultMaxWalkSpeed;
    }
}

bool ALumaPaperCharacter::IsWebbed() const
{
    return bIsWebbed;
}

// 🚫 Springen blockieren
bool ALumaPaperCharacter::CanJumpInternal_Implementation() const
{
    if (bIsWebbed)
        return false;

    return Super::CanJumpInternal_Implementation();
}
/**
// Called every frame
void ALumaPaperCharacter::Tick(float DeltaTime)
{
    Super::Tick(DeltaTime);

}

// Called to bind functionality to input
void ALumaPaperCharacter::SetupPlayerInputComponent(UInputComponent* PlayerInputComponent)
{
    Super::SetupPlayerInputComponent(PlayerInputComponent);

}

// ===== ENERGY =====
void ALumaPaperCharacter::ChangeEnergy(float Amount)
{
    CurrentEnergy = FMath::Clamp(CurrentEnergy + Amount, 0.f, MaxEnergy);
}

// ===== STATE (MOVABLE) =====
void ALumaPaperCharacter::DisableMovement()
{
    bMovementLocked = true;
    //GetCharacterMovement()->DisableMovement();
}

void ALumaPaperCharacter::EnableMovement()
{
    bMovementLocked = false;
    //GetCharacterMovement()->SetMovementMode(MOVE_Walking);
}*/
