// Copyright Epic Games, Inc. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/GameModeBase.h"
#include "LumaGameMode.generated.h"

UENUM(BlueprintType)
enum class EGameState : uint8
{
    MainMenu,
    InGame,
    Pause,
    GameOver,
    Win
};

UCLASS(abstract)
class ALumaGameMode : public AGameModeBase
{
    GENERATED_BODY()

public:
    
    /** Constructor */
    ALumaGameMode();
    
    /**state**/
    UPROPERTY(BlueprintReadOnly)
    EGameState State;
    
    //current level
    UPROPERTY(EditAnywhere, BlueprintReadOnly)
    FName CurrentLevel;
    
    //start level
    UFUNCTION(BlueprintCallable)
    void StartLevel();
    
    //back to menu
    UFUNCTION(BlueprintCallable)
    void BackToMenu();
};


