// Copyright Epic Games, Inc. All Rights Reserved.

#include "LumaGameMode.h"
#include "Kismet/GameplayStatics.h"

ALumaGameMode::ALumaGameMode()
{
    State = EGameState::MainMenu;
    CurrentLevel = NAME_None;
}

void ALumaGameMode::StartLevel()
{
    State = EGameState::InGame;
    
    if (!CurrentLevel.IsNone())
    {
        UGameplayStatics::OpenLevel(this, CurrentLevel);
    }
}

void ALumaGameMode::BackToMenu()
{
    State = EGameState::MainMenu;
    UGameplayStatics::OpenLevel(this, "MainMenu");
}
