// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Obstacle.h"
#include "LightParticle.generated.h"

/**
 * LightParticle Obstacle
 * Collectible particle that grants light energy
 */
UCLASS()
class LUMA2DSCROLLER_API ALightParticle : public AObstacle
{
	GENERATED_BODY()

public:
	// Sets default values
	ALightParticle();

protected:
	/** Amount of light granted when collected */
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category="LightParticle|Properties")
	int32 EnergyAmount;
    
    virtual void OnPlayerEnter(ALumaPaperCharacter* Player) override;
};
